import java.net.*;
import java.io.*;
import java.util.Vector;

public class EchoServerConsole
{
  protected Vector<EchoServerCommThread> threadList;
  protected EchoServerNetThread esNetThread = null;
  protected BufferedReader brInput = null;
  public EchoServerConsole()
  {
    threadList = new Vector<EchoServerCommThread>();
    esNetThread = new EchoServerNetThread(this, 6666);
    esNetThread.start();
    try{
      brInput = new BufferedReader(
        new InputStreamReader(System.in));
    }
    catch(Exception e){
      log("Bd przy tworzeniu strumienia wejciowego: " + e);
      System.exit(-1);
    }
  }
  public static void main(String args[])
  {
    EchoServerConsole escon = new EchoServerConsole();
    escon.start();
  }
  public void start()
  {
    String line;
    while(true){
      try{
        System.out.print(">");
        line = brInput.readLine();
        if (line.equals("quit")){
          shutdown();
        }
        else if (line.equals("status")){
          showStatus();
        }
        else if (line.equals("help")){
          showHelp();
        }
        else{
          System.out.println(
            "Nieznane polecenie. Wpisz help, aby uzyska pomoc.");
        }
      }
      catch(IOException e){
        log("Bd wejcia-wyjcia: " + e);
        System.exit(-1);
      }
      catch(Exception e){
        log("Bd oglny: " + e);
        System.exit(-1);
      }
    }
  }
  //dalsze metody klasy EchoServerConsole
}
